
//Program to find out load flow solution using Newton Raphson method//
//This program requires user input. A sample problem with user input and output is available in the result file//
//Example problem is available in the file "NRQuestionFile.jpg" and user input and output is available in the file "NRResultFile"
//Scilab Version 5.5.2 ; OS:Windows

clear;
clc;
linedata=input('Enterlinedata in the order line no.,Frombus,Tobus,series resistance,series reactance,Line charging admittance:');
Busdata=input('Enter busdata in the order busno.,real power,reativepower,busvoltage,bus type 1-for slack 2-for PQ and 3-for PV:');
npv=input('Enter the number of PV bus:');

//Determination of bus admittance matrix//
nb=max(Busdata(:,1));
nl=max(linedata(:,1));
Psp=Busdata(:,2);
Qsp=Busdata(:,3);
vsp=Busdata(:,4);
rem=Busdata(:,5);
Y=zeros(nb,nb);
sb=linedata(:,2);
eb=linedata(:,3);
z=linedata(:,4)+linedata(:,5)*%i;
ly=linedata(:,6);
for i=1:nl
    m=sb(i)
    n=eb(i);
    Y(m,m)=Y(m,m)+1/z(i)+ly(i)/2;
    Y(n,n)=Y(n,n)+1/z(i)+ly(i)/2;
    Y(m,n)=-1/z(i);
    Y(n,m)=Y(m,n);
   end
disp('Bus admittance matrix')
print(%io(2),Y)

//NR Load flow//
absY=abs(Y);
thetaY=atan(imag(Y),real(Y));
v=vsp';
iteration=1;
ang=zeros(1,nb);
mismatch=ones(2*nb-2-npv,1);
while max(abs(mismatch))>0.0001
    J1=zeros(nb-1,nb-1);
    J2=zeros(nb-1,nb-npv-1);
    J3=zeros(nb-npv-1,nb-1);
    J4=zeros(nb-npv-1,nb-npv-1);
    P=zeros(nb,1);
    Q=P;
    del_P=Q;
    del_Q=Q;
    del_del=zeros(nb-1,1);
    del_v=zeros(nb-1-npv,1);
    ang;
    mag=abs(v);
    for i=2:nb
        for j=1:nb
            P(i)=P(i)+mag(i)*mag(j)*absY(i,j)*cos(thetaY(i,j)-ang(i)+ang(j));
             if rem(i)~=3
                  Q(i)=Q(i)+mag(i)*mag(j)*absY(i,j)*sin(thetaY(i,j)-ang(i)+ang(j));
              end
          end
          end
Q=-1*Q;
del_P=Psp-P;
del_Q=Qsp-Q;
for i=2:nb
    for j=2:nb
        if j~=i
            J1(i-1,j-1)=-mag(i)*mag(j)*absY(i,j)*sin(thetaY(i,j)-ang(i)+ang(j));
            J2(i-1,j-1)=mag(i)*absY(i,j)*cos(thetaY(i,j)-ang(i)+ang(j));
            J3(i-1,j-1)=-mag(i)*mag(j)*absY(i,j)*cos(thetaY(i,j)-ang(i)+ang(j));
            J4(i-1,j-1)=-mag(i)*absY(i,j)*sin(thetaY(i,j)-ang(i)+ang(j));
        end
    end
end
for i=2:nb
    for j=1:nb
        if j~=i
            J1(i-1,i-1)=J1(i-1,i-1)+mag(i)*mag(j)*absY(i,j)*sin(thetaY(i,j)-ang(i)+ang(j));
            J2(i-1,i-1)=J2(i-1,i-1)+mag(j)*absY(i,j)*cos(thetaY(i,j)-ang(i)+ang(j));
            J3(i-1,i-1)=J3(i-1,i-1)+mag(i)*mag(j)*absY(i,j)*cos(thetaY(i,j)-ang(i)+ang(j));
            J4(i-1,i-1)=J4(i-1,i-1)+mag(j)*absY(i,j)*sin(thetaY(i,j)-ang(i)+ang(j));
        end
    end
    J2(i-1,i-1)=2*mag(i)*absY(i,i)*cos(thetaY(i,i))+J2(i-1,i-1);
    J4(i-1,i-1)=-2*mag(i)*absY(i,i)*sin(thetaY(i,i))-J4(i-1,i-1);
    end
J=[J1 J2;J3 J4]
lenJ=length(J1);
i=2;
j=1;
while j<=lenJ
    if rem(i)==2
        j=j+1;
    else
        J(:,length(J1)+j)=[];
        lenJ=lenJ-1;
    end
end
i=i+1;
lenJ=length(J1);
i=1;
j=2;
while i<=lenJ
    if rem(j)==2
        i=i+1;
    else
        J(length(J1)+i,:)=[];
        lenJ=lenJ-1;
        Q(i+1)=[]
        del_Q(i+1,:)=[]
    end
  //  j=j+1;
    end
P(1,:)=[]
Q(1,:)=[]
del_P(1,:)=[];
del_Q(1,:)=[];
mismatch=[del_P;del_Q];
del=J\mismatch;
del_del=del(1:nb-1);
del_v=del(nb:length(del));
ang=ang(2:nb)+del_del';
j=1;
for i=2:nb
    if rem(i)==2
        v(i)=v(i)+del_v(j);
        j=j+1;
    end
end
mag=abs(v);
ang=[0 ang];
nbr=1:nb;
iteration=iteration+1;
end    
disp(iteration-1,'The load flow solution cnverged at iteration')
disp('bus no   Type   voltage   angle')
disp([nbr' rem mag' ang'])    


//SAMPLE INPUT and OUTPUT:
//Enterlinedata in the order line no.,Frombus,Tobus,series resistance,series reactance,Line charging admittance:[1 1 2 0.02 0.04 0;2 2 3 0.0125 0.025 0;3 3 1 0.01 0.03 0]
//Enter busdata in the order busno.,real power,reativepower,busvoltage,bus type 1-for slack 2-for PQ and 3-for PV:[1 0 0 1.05 1;2 -2.566 -1.102 1 2;3 -1.386 -0.452 1 2]
//Enter the number of PV bus:0
 
// Bus admittance matrix   
// Y  =
 
//    20. - 50.i  - 10. + 20.i  - 10. + 30.i  
//  - 10. + 20.i    26. - 52.i  - 16. + 32.i  
//  - 10. + 30.i  - 16. + 32.i    26. - 62.i  
 
// The load flow solution cnverged at iteration   
 
//    4.  
 
// bus no   Type   voltage   angle   
 
//    1.    1.    1.05         0.         
//    2.    2.    0.9818350  - 0.0611482  
//    3.    2.    1.0012492  - 0.0499584  
 



                   
                                
